/*
 * 쐬: 2008/08/05
 * 쌠: Copyright (c) 2005 ZIGEN
 * CZXFEclipse Public License - v 1.0
 * Fhttp://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import zigen.plugin.db.ext.s2jdbc.util.CodeCreatorUtil;
import zigen.plugin.db.ui.views.TreeView;

public abstract class AbstractWizardPage extends NewClassWizardPage {
	
	protected static final String LS = System.getProperty("line.separator");
	
	protected IStructuredSelection selection;
	
	protected Text entityText;
	
	protected TreeView treeView;
	
	protected IType fCurrType;
	
	
	public AbstractWizardPage(IStructuredSelection selection, String title) {
		super();
		super.init(selection);
		setTitle(title);
		this.selection = selection;
		setPageComplete(false);
	}
	
	public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setFont(parent.getFont());
		int nColumns = 4;
		GridLayout layout = new GridLayout();
		layout.numColumns = nColumns;
		composite.setLayout(layout);
		createContainerControls(composite, nColumns);
		createPackageControls(composite, nColumns);
		createEnclosingTypeControls(composite, nColumns);
		createSeparator(composite, nColumns);
		
		// gRg[
		addPreTypeNameControl(composite, nColumns);
		
		createTypeNameControls(composite, nColumns);
		
		// gRg[
		addAfterTypeNameControl(composite, nColumns);
		
		// createModifierControls(composite, nColumns);
		createSuperClassControls(composite, nColumns);
		createSuperInterfacesControls(composite, nColumns);
		

		// \bhX^uI(ON)
		// createMethodStubSelectionControls(composite, nColumns);
		createCommentControls(composite, nColumns);
		enableCommentControl(true);
		setControl(composite);
		Dialog.applyDialogFont(composite);
		PlatformUI.getWorkbench().getHelpSystem().setHelp(composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
	}
	
	abstract public void addPreTypeNameControl(Composite parent, int nColumns);
	
	abstract public void addAfterTypeNameControl(Composite parent, int nColumns);
	
	
	// vpeB̎擾
	protected final String propertyString(String accessModifiers, String type, String property) {
		return CodeCreatorUtil.propertyString(accessModifiers, type, property);
	}
	
	// toString̎擾
	protected final String toStringString(String className, String[] properties) {
		return CodeCreatorUtil.toStringString(className, properties);
	}
	
	protected final String getDefaultCharset() {
		String charset = "UTF-8";
		try {
			IWorkspace workspace = ResourcesPlugin.getWorkspace();
			IProject project = workspace.getRoot().getProject(getJavaProject().getElementName());
			charset = project.getDefaultCharset();
			
		} catch (CoreException e1) {
			e1.printStackTrace();
		}
		
		return charset;
	}
	
}